#include <stdint.h>

void opus_multistream_decoder_ctl();
void opus_multistream_decoder_destroy();
void opus_multistream_decode_float();
void opus_multistream_decode();
void opus_strerror();
void opus_multistream_decoder_create();
void speex_bits_reset();
void speex_bits_destroy();
void speex_decoder_destroy();
void speex_bits_remaining();
void speex_bits_read_from();
void speex_decode_int();
void speex_bits_peek_unsigned();
void speex_decode_stereo_int();
void speex_packet_to_header();
void speex_header_free();
void speex_lib_get_mode();
void iconv_connect();
void iconv();
void iconv_open();
void iconv_close();
// void vbi_classify_page();
// void vbi_decode();
// void vbi_decoder_delete();
// void vbi_decoder_new();
// void vbi_draw_vt_page_region();
// void vbi_event_handler_add();
// void vbi_export_errstr();
// void vbi_export_new();
// void vbi_export_stdio();
// void vbi_fetch_vt_page();
// void vbi_print_page_region();
// void vbi_unref_page();
// void vbi_version();
// void vbi_event_handler_register();
// void vbi_teletext_set_default_region();
void ModPlug_GetCurrentSpeed();
void ModPlug_GetCurrentTempo();
void ModPlug_GetCurrentOrder();
void ModPlug_GetCurrentPattern();
void ModPlug_GetCurrentRow();
void ModPlug_GetName();
void ModPlug_GetMessage();
void ModPlug_GetLength();
void ModPlug_GetSettings();
void ModPlug_InstrumentName();
void ModPlug_Load();
void ModPlug_NumInstruments();
void ModPlug_NumSamples();
void ModPlug_NumPatterns();
void ModPlug_NumChannels();
void ModPlug_SampleName();
void ModPlug_Seek();
void ModPlug_SetSettings();
void ModPlug_Read();
void ModPlug_Unload();

//added for ssl & crypto
void SSL_library_init();
void SSL_load_error_strings();
void SSL_shutdown();
void SSL_new();
void SSL_free();
void SSL_set_fd();
void SSL_accept();
void SSL_connect();
void SSL_read();
void SSL_write();
void SSL_ctrl();
void SSL_get_error();
void SSL_set_bio();
void SSLv23_server_method();
void SSLv23_client_method();
void TLSv1_client_method();
void TLSv1_server_method();
void SSL_CTX_free();
void SSL_CTX_new();
void SSL_CTX_load_verify_locations();
void SSL_CTX_use_certificate_chain_file();
void SSL_CTX_use_PrivateKey_file();
void SSL_CTX_set_verify();
void SSL_CTX_ctrl();
void CRYPTO_get_locking_callback();
void CRYPTO_num_locks();
void CRYPTO_set_locking_callback();
void DH_new();
void DH_free();
void DH_size();
void DH_generate_key();
void DH_compute_key();
void BN_new();
void BN_hex2bn();
void BN_bn2bin();
void BN_bin2bn();
void BN_set_word();
void BN_cmp();
void BN_copy();
void BN_sub_word();
void BN_free();
void BN_CTX_new();
void BN_CTX_free();
void BN_mod_exp();
void BN_value_one();
void BN_num_bits();
void BN_rand();
void BIO_new();
void BIO_clear_flags();
void BIO_set_flags();
void ERR_get_error();
void ERR_error_string();

//added for libxml2
void xmlCheckVersion();
void xmlNodeGetContent();
void xmlFree();
void xmlGetProp();
void xmlFirstElementChild();
void xmlNextElementSibling();
void xmlReadMemory();
void xmlDocGetRootElement();
void xmlFreeDoc();
void xmlCleanupParser();
void xmlFreeNode();
void xmlNewNode();
void xmlCopyNode();
void xmlNodeSetContent();

//added for libsmb2
void smb2_init_context();
void smb2_destroy_context();
void smb2_parse_url();
void smb2_destroy_url();
void smb2_set_user();
void smb2_set_password();
void smb2_set_domain();
void smb2_set_security_mode();
void smb2_connect_share_async();
void smb2_disconnect_share_async();
void smb2_get_error();
void smb2_open_async();
void smb2_fstat_async();
void smb2_stat_async();
void smb2_get_max_read_size();
void smb2_lseek();
void smb2_read_async();
void smb2_write_async();
void smb2_close_async();
void smb2_opendir_async();
void smb2_readdir();
void smb2_rmdir_async();
void smb2_closedir();
void smb2_unlink_async();
void smb2_rename_async();
void smb2_get_fd();
void smb2_which_events();
void smb2_service();
void smb2_share_enum_async();
void smb2_free_data();

//added for dav1d
void dav1d_version();
void dav1d_default_settings();
void dav1d_open();
void dav1d_data_unref();
void dav1d_flush();
void dav1d_data_wrap();
void dav1d_data_wrap_user_data();
void dav1d_send_data();
void dav1d_get_picture();
void dav1d_picture_unref();
void dav1d_close();

//added for mxv
void mxv_demuxer_connect();
void mxv_probe();
void mxv_read_header();
void mxv_read_packet();
void mxv_read_seek();
void mxv_read_close();
void mxv_muxer_connect();
int mxv_init();
int mxv_write_header();
int mxv_write_flush_packet();
int mxv_write_trailer();
int mxv_query_codec();
int mxv_check_bitstream();

// added for mxd
void mxd_connect();
void mxd_read_probe();
void mxd_read_header();
void mxd_read_packet();
void mxd_read_seek();
void mxd_read_close();

// extern const uint8_t _vbi_bit_reverse[256];
// extern const int8_t	_vbi_hamm8_inv [256];
// extern const uint8_t _vbi_hamm8_fwd [16];


void lame_init();
void lame_set_num_channels();
void lame_set_mode();
void lame_set_in_samplerate();
void lame_set_out_samplerate();
void lame_set_quality();
void lame_set_VBR();
void lame_set_VBR_mean_bitrate_kbps();
void lame_set_VBR_quality();
void lame_set_lowpassfreq();
void lame_set_bWriteVbrTag();
void lame_set_disable_reservoir();
void lame_init_params();
void lame_get_encoder_delay();
void lame_get_framesize();
void lame_set_brate();
void lame_encode_buffer();
void lame_encode_flush();
void lame_encode_buffer_int();
void lame_encode_buffer_float();
void lame_close();

// Dummy function to export functions from static libraries.

void dummy_main()
{
    // if( _vbi_bit_reverse[0] == 1 )
    //     return;

    // if ( _vbi_hamm8_inv[0] == 0x01 )
    //     return;

    // if ( _vbi_hamm8_fwd[0] == 0x15 )
    //     return;

    opus_multistream_decoder_ctl();
    opus_multistream_decoder_destroy();
    opus_multistream_decode_float();
    opus_multistream_decode();
    opus_strerror();
    opus_multistream_decoder_create();
    speex_bits_reset();
    speex_bits_destroy();
    speex_decoder_destroy();
    speex_bits_remaining();
    speex_bits_read_from();
    speex_decode_int();
    speex_bits_peek_unsigned();
    speex_decode_stereo_int();
    speex_packet_to_header();
    speex_header_free();
    speex_lib_get_mode();
    iconv_connect();
    iconv();
    iconv_open();
    iconv_close();
    // vbi_classify_page();
    // vbi_decode();
    // vbi_decoder_delete();
    // vbi_decoder_new();
    // vbi_draw_vt_page_region();
    // vbi_event_handler_add();
    // vbi_export_errstr();
    // vbi_export_new();
    // vbi_export_stdio();
    // vbi_fetch_vt_page();
    // vbi_print_page_region();
    // vbi_unref_page();
    // vbi_version();
    // vbi_event_handler_register();
    // vbi_teletext_set_default_region();
    ModPlug_GetCurrentSpeed();
    ModPlug_GetCurrentTempo();
    ModPlug_GetCurrentOrder();
    ModPlug_GetCurrentPattern();
    ModPlug_GetCurrentRow();
    ModPlug_GetName();
    ModPlug_GetMessage();
    ModPlug_GetLength();
    ModPlug_GetSettings();
    ModPlug_InstrumentName();
    ModPlug_Load();
    ModPlug_NumInstruments();
    ModPlug_NumSamples();
    ModPlug_NumPatterns();
    ModPlug_NumChannels();
    ModPlug_SampleName();
    ModPlug_Seek();
    ModPlug_SetSettings();
    ModPlug_Read();
    ModPlug_Unload();

    //added for ssl & crypto
    SSL_library_init();
    SSL_load_error_strings();
    SSL_shutdown();
    SSL_new();
    SSL_free();
    SSL_set_fd();
    SSL_accept();
    SSL_connect();
    SSL_read();
    SSL_write();
    SSL_ctrl();
    SSL_get_error();
    SSL_set_bio();
    SSLv23_server_method();
    SSLv23_client_method();
    TLSv1_client_method();
    TLSv1_server_method();
    SSL_CTX_free();
    SSL_CTX_new();
    SSL_CTX_load_verify_locations();
    SSL_CTX_use_certificate_chain_file();
    SSL_CTX_use_PrivateKey_file();
    SSL_CTX_set_verify();
    SSL_CTX_ctrl();
    CRYPTO_get_locking_callback();
    CRYPTO_num_locks();
    CRYPTO_set_locking_callback();
    DH_new();
    DH_free();
    DH_size();
    DH_generate_key();
    DH_compute_key();
    BN_new();
    BN_hex2bn();
    BN_bn2bin();
    BN_bin2bn();
    BN_set_word();
    BN_cmp();
    BN_copy();
    BN_sub_word();
    BN_free();
    BN_CTX_new();
    BN_CTX_free();
    BN_mod_exp();
    BN_value_one();
    BN_num_bits();
    BN_rand();
    BIO_new();
    BIO_clear_flags();
    BIO_set_flags();
    ERR_get_error();
    ERR_error_string();

    //added for libxml2
    xmlCheckVersion();
    xmlNodeGetContent();
    xmlFree();
    xmlGetProp();
    xmlFirstElementChild();
    xmlNextElementSibling();
    xmlReadMemory();
    xmlDocGetRootElement();
    xmlFreeDoc();
    xmlCleanupParser();
    xmlFreeNode();
    xmlNewNode();
    xmlCopyNode();
    xmlNodeSetContent();

    //added for libsmb2
    smb2_init_context();
    smb2_destroy_context();
    smb2_parse_url();
    smb2_destroy_url();
    smb2_set_user();
    smb2_set_password();
    smb2_set_domain();
    smb2_set_security_mode();
    smb2_connect_share_async();
    smb2_disconnect_share_async();
    smb2_get_error();
    smb2_open_async();
    smb2_fstat_async();
    smb2_stat_async();
    smb2_get_max_read_size();
    smb2_lseek();
    smb2_read_async();
    smb2_write_async();
    smb2_close_async();
    smb2_opendir_async();
    smb2_readdir();
    smb2_rmdir_async();
    smb2_closedir();
    smb2_unlink_async();
    smb2_rename_async();
    smb2_get_fd();
    smb2_which_events();
    smb2_service();
    smb2_share_enum_async();
    smb2_free_data();

    //added for libdav1d
    dav1d_version();
    dav1d_default_settings();
    dav1d_open();
    dav1d_data_unref();
    dav1d_flush();
    dav1d_data_wrap();
    dav1d_data_wrap_user_data();
    dav1d_send_data();
    dav1d_get_picture();
    dav1d_picture_unref();
    dav1d_close();

    //added for mxv
    mxv_demuxer_connect();
    mxv_probe();
    mxv_read_header();
    mxv_read_packet();
    mxv_read_seek();
    mxv_read_close();
    mxv_muxer_connect();
    mxv_init();
    mxv_write_header();
    mxv_write_flush_packet();
    mxv_write_trailer();
    mxv_query_codec();
    mxv_check_bitstream();

    mxd_connect();
    mxd_read_probe();
    mxd_read_header();
    mxd_read_packet();
    mxd_read_seek();
    mxd_read_close();

    //libmp3lame
    lame_init();
    lame_set_num_channels();
    lame_set_mode();
    lame_set_in_samplerate();
    lame_set_out_samplerate();
    lame_set_quality();
    lame_set_VBR();
    lame_set_VBR_mean_bitrate_kbps();
    lame_set_VBR_quality();
    lame_set_lowpassfreq();
    lame_set_bWriteVbrTag();
    lame_set_disable_reservoir();
    lame_init_params();
    lame_get_encoder_delay();
    lame_get_framesize();
    lame_set_brate();
    lame_encode_buffer();
    lame_encode_flush();
    lame_encode_buffer_int();
    lame_encode_buffer_float();
    lame_close();
}
