#include <stdlib.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*psftp_open)(void* context, const char* url, int flags, const char* privateKey);
typedef int (*psftp_read)(void* context, unsigned char* buf, int size);
typedef int (*psftp_write)(void* context, const unsigned char* buf, int size);
typedef int64_t (*psftp_seek)(void* context, int64_t pos, int whence);
typedef int (*psftp_close)(void* context);
typedef int (*psftp_open_dir)(void* context);
typedef int (*psftp_read_dir)(void* context, void** next);
typedef int (*psftp_close_dir)(void* context);
typedef int (*psftp_delete)(void* context);
typedef int (*psftp_move)(void* src, void* dst);

void sftp_connect(psftp_open open, psftp_read read, psftp_write write, psftp_seek seek,
                  psftp_close close, psftp_open_dir open_dir, psftp_read_dir read_dir,
                  psftp_close_dir close_dir, psftp_delete delete_, psftp_move move);

int sftp_open(void* context, const char* url, int flags, const char* privateKey);
int sftp_read(void* context, unsigned char* buf, int size);
int sftp_write(void* context, const unsigned char* buf, int size);
int64_t sftp_seek(void* context, int64_t pos, int whence);
int sftp_close(void* context);
int sftp_open_dir(void* context);
int sftp_read_dir(void* context, void** next);
int sftp_close_dir(void* context);
int sftp_delete(void* context);
int sftp_move(void* src, void* dst);

#ifdef __cplusplus
}   // extern "C"
#endif
