#include "sftp_wrap.h"

static psftp_open g_sftp_open = NULL;
static psftp_read g_sftp_read = NULL;
static psftp_write g_sftp_write = NULL;
static psftp_seek g_sftp_seek = NULL;
static psftp_close g_sftp_close = NULL;
static psftp_open_dir g_sftp_open_dir = NULL;
static psftp_read_dir g_sftp_read_dir = NULL;
static psftp_close_dir g_sftp_close_dir = NULL;
static psftp_delete g_sftp_delete = NULL;
static psftp_move g_sftp_move = NULL;

void sftp_connect(psftp_open open, psftp_read read, psftp_write write, psftp_seek seek,
                  psftp_close close, psftp_open_dir open_dir, psftp_read_dir read_dir,
                  psftp_close_dir close_dir, psftp_delete delete_, psftp_move move)
{
    g_sftp_open = open;
    g_sftp_read = read;
    g_sftp_write = write;
    g_sftp_seek = seek;
    g_sftp_close = close;
    g_sftp_open_dir = open_dir;
    g_sftp_read_dir = read_dir;
    g_sftp_close_dir = close_dir;
    g_sftp_delete = delete_;
    g_sftp_move = move;
}

int sftp_open(void* context, const char* url, int flags, const char* privateKey)
{
    return g_sftp_open ? g_sftp_open(context, url, flags, privateKey) : -1;
}

int sftp_read(void* context, unsigned char* buf, int size)
{
    return g_sftp_read ? g_sftp_read(context, buf, size) : -1;
}

int sftp_write(void* context, const unsigned char* buf, int size)
{
    return g_sftp_write ? g_sftp_write(context, buf, size) : -1;
}

int64_t sftp_seek(void* context, int64_t pos, int whence)
{
    return g_sftp_seek ? g_sftp_seek(context, pos, whence) : -1;
}

int sftp_close(void* context)
{
    return g_sftp_close ? g_sftp_close(context) : -1;
}

int sftp_open_dir(void* context)
{
    return g_sftp_open_dir ? g_sftp_open_dir(context) : -1;
}

int sftp_read_dir(void* context, void** next)
{
    return g_sftp_read_dir ? g_sftp_read_dir(context, next) : -1;
}

int sftp_close_dir(void* context)
{
    return g_sftp_close_dir ? g_sftp_close_dir(context) : -1;
}

int sftp_delete(void* context)
{
    return g_sftp_delete ? g_sftp_delete(context) : -1;
}

int sftp_move(void* src, void* dst)
{
    return g_sftp_move ? g_sftp_move(src, dst) : -1;
}
