#include <stdlib.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*pftps_open)(void* context, const char* url, int flags, int implicit, int passive, const char* encoding);
typedef int (*pftps_read)(void* context, unsigned char* buf, int size);
typedef int (*pftps_write)(void* context, const unsigned char* buf, int size);
typedef int64_t (*pftps_seek)(void* context, int64_t pos, int whence);
typedef int (*pftps_close)(void* context);
typedef int (*pftps_open_dir)(void* context);
typedef int (*pftps_read_dir)(void* context, void** next);
typedef int (*pftps_close_dir)(void* context);
typedef int (*pftps_delete)(void* context);
typedef int (*pftps_move)(void* src, void* dst);

void ftps_connect(pftps_open open, pftps_read read, pftps_write write, pftps_seek seek,
                  pftps_close close, pftps_open_dir open_dir, pftps_read_dir read_dir,
                  pftps_close_dir close_dir, pftps_delete delete_, pftps_move move);

int ftps_open(void* context, const char* url, int flags, int implicit, int passive, const char* encoding);
int ftps_read(void* context, unsigned char* buf, int size);
int ftps_write(void* context, const unsigned char* buf, int size);
int64_t ftps_seek(void* context, int64_t pos, int whence);
int ftps_close(void* context);
int ftps_open_dir(void* context);
int ftps_read_dir(void* context, void** next);
int ftps_close_dir(void* context);
int ftps_delete(void* context);
int ftps_move(void* src, void* dst);

#ifdef __cplusplus
}   // extern "C"
#endif
