#include "ftps_wrap.h"

static pftps_open      _pftps_open;
static pftps_read      _pftps_read;
static pftps_write     _pftps_write;
static pftps_seek      _pftps_seek;
static pftps_close     _pftps_close;
static pftps_open_dir  _pftps_open_dir;
static pftps_read_dir  _pftps_read_dir;
static pftps_close_dir _pftps_close_dir;
static pftps_delete    _pftps_delete;
static pftps_move      _pftps_move;

void ftps_connect(pftps_open open, pftps_read read, pftps_write write, pftps_seek seek,
                  pftps_close close, pftps_open_dir open_dir, pftps_read_dir read_dir,
                  pftps_close_dir close_dir, pftps_delete delete_, pftps_move move)
{
    _pftps_open      = open;
    _pftps_read      = read;
    _pftps_write     = write;
    _pftps_seek      = seek;
    _pftps_close     = close;
    _pftps_open_dir  = open_dir;
    _pftps_read_dir  = read_dir;
    _pftps_close_dir = close_dir;
    _pftps_delete    = delete_;
    _pftps_move      = move;
}

int ftps_open(void* context, const char* url, int flags, int implicit, int passive, const char* encoding)
{
    return _pftps_open ? _pftps_open(context, url, flags, implicit, passive, encoding) : -1;
}

int ftps_read(void* context, unsigned char* buf, int size)
{
    return _pftps_read ? _pftps_read(context, buf, size) : -1;
}

int ftps_write(void* context, const unsigned char* buf, int size)
{
    return _pftps_write ? _pftps_write(context, buf, size) : -1;
}

int64_t ftps_seek(void* context, int64_t pos, int whence)
{
    return _pftps_seek ? _pftps_seek(context, pos, whence) : -1;
}

int ftps_close(void* context)
{
    return _pftps_close ? _pftps_close(context) : -1;
}

int ftps_open_dir(void* context)
{
    return _pftps_open_dir ? _pftps_open_dir(context) : -1;
}

int ftps_read_dir(void* context, void** next)
{
    return _pftps_read_dir ? _pftps_read_dir(context, next) : -1;
}

int ftps_close_dir(void* context)
{
    return _pftps_close_dir ? _pftps_close_dir(context) : -1;
}

int ftps_delete(void* context)
{
    return _pftps_delete ? _pftps_delete(context) : -1;
}

int ftps_move(void* src, void* dst)
{
    return _pftps_move ? _pftps_move(src, dst) : -1;
}
